/* string.c
 * Copyright (C) 2000, Tsurishaddai Williamson, tsuri@earthlink.net
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**********************************************************************/

#include <ctype.h>
#include "string.h"

/* strcasecmp() compares strings, upper and lower case equivalent. */
int strcasecmp(const char *s1, const char *s2)
{
	int result;

	while ((result = (toupper(*s1) - toupper(*s2++))) == 0)
		if (*s1++ == 0)
			break;

	return result;

}

/* strcasecpy() copies a string, converting lower to upper case. */
char *strcasecpy(char *d, const char *s)
{
	char *result = d;

	while ((*d++ = toupper(*s++)) != 0)
		;

	return result;

}
