; CBIOS63.ASM - uSim 64K CP/M BIOS
; Copyright (C) 2000  Tsurishaddai Williamson, tsuri@earthlink.net
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version 2
; of the License, or (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

; 63.5K CP/M LOCATIONS
MEMSIZ	EQU	64			; MEMORY SIZE, KILOBYTES
CPMVER	EQU	22			; CP/M VERSION
CCP	EQU	3200H+(MEMSIZ-20)*1024	; CCP BASE ADDRESS
BDOS	EQU	CCP+0800H		; BDOS BASE ADDRESS
BIOS	EQU	CCP+1600H		; BIOS BASE ADDRESS
DATA	EQU	BIOS+(2300H-1F80H)	; BIOS UNINITIALIZED DATA ADDRESS
REBOOT	EQU	0000H			; "JMP REBOOT" TO REBOOT
IOBYTE	EQU	0003H			; ADDRESS OF I/O BYTE VARIABLE
USRDSK	EQU	0004H			; ADDRESS OF USER NUMBER / CURRENT VARIABLE
SYSTEM	EQU	0005H			; "CALL SYSTEM" FOR SYSTEM CALL
USRFCB	EQU	005CH			; ADDRESS OF DEFAULT FILE CONTROL BLOCK
USRBUF	EQU	0080H			; ADDRESS OF DEFAULT I/O BUFFER
USRTPA	EQU	0100H			; ADDRESS OF TRANSIANT PROGRAM AREA

; uSim i8080 SIMULATOR 0.8
; SYSTEM.EQU GENERATED BY uSim main.c

;SYSTEM FLAGS
SYSFLG	EQU	0	; SYSTEM CONTROL/STATUS PORT
SYSSW0	EQU	1	; SYSTEM SWITCH BIT #0
SYSSW1	EQU	2	; SYSTEM SWITCH BIT #1
SYSSW2	EQU	4	; SYSTEM SWITCH BIT #2
SYSSW3 	EQU	8	; SYSTEM SWITCH BIT #3
SYSSW4	EQU	16	; SYSTEM SWITCH BIT #4
SYSSW5	EQU	32	; SYSTEM SWITCH BIT #5
SYSSW6	EQU	64	; SYSTEM SWITCH BIT #6
SYSSW7	EQU	128	; SYSTEM SWITCH BIT #7
SYSLT0	EQU	1	; SYSTEM LIGHT BIT #0
SYSLT1	EQU	2	; SYSTEM LIGHT BIT #1
SYSLT2	EQU	4	; SYSTEM LIGHT BIT #2
SYSLT3	EQU	8	; SYSTEM LIGHT BIT #3
SYSLT4	EQU	16	; SYSTEM LIGHT BIT #4
SYSLT5	EQU	32	; SYSTEM LIGHT BIT #5
SYSLT6	EQU	64	; SYSTEM LIGHT BIT #6
SYSLT7	EQU	128	; SYSTEM LIGHT BIT #7
SYSRES	EQU	1	; RESET IF BIT SET
SYSMON	EQU	2	; MONITOR IF BIT SET
SYSHLT	EQU	4	; HALT IF BIT SET
SYSBRK	EQU	8	; BREAK IF BIT SET

; SYSTEM IDENTIFICATION
SYSID0	EQU	1	; SYSTEM ID LOW WORD, LOW BYTE PORT
SYSID1	EQU	2	; SYSTEM ID LOW WORD, HIGH BYTE PORT
SYSID2	EQU	3	; SYSTEM ID HIGH WORD, LOW BYTE PORT
SYSID3	EQU	4	; SYSTEM ID HIGH WORD, HIGH BYTE PORT

; MEMORY MANAGEMENT
ROMSIZ	EQU	64	; TOTAL KILOBYTES ROM
RAMSIZ	EQU	64	; TOTAL KILOBYTES RAM
BANK0	EQU	5	; MEMORY BANK (0000H-3FFFH) PORT
BANK1	EQU	6	; MEMORY BANK (4000H-7FFFH) PORT
BANK2	EQU	7	; MEMORY BANK (8000H-BFFFH) PORT
BANK3	EQU	8	; MEMORY BANK (C000H-FFFFH) PORT
BNKSIZ	EQU	16384	; TOTAL BYTES IN A MEMORY BANK
MINROM	EQU	0	; FIRST ROM INDEX
MAXROM	EQU	3	; LAST ROM INDEX
MINRAM	EQU	4	; FIRST RAM INDEX
MAXRAM	EQU	7	; LAST RAM INDEX
DMAHI	EQU	9	; DMA HIGH BYTE PORT
DMALO	EQU	10	; DMA LOW BYTE PORT

; CHARACTER STREAM DEVICE
DEVCTL	EQU	11	; DEVICE CONTROL/STATUS PORT
DEVTTY	EQU	0	; TTY CONSOLE DEVICE
DEVCRT	EQU	1	; CRT CONSOLE DEVICE
DEVUC1	EQU	2	; USER DEFINED CONSOLE DEVICE #1
DEVUC2	EQU	3	; USER DEFINED CONSOLE DEVICE #2
DEVPTR	EQU	4	; PAPER TAPE READER DEVICE
DEVUR1	EQU	5	; USER DEFINED READER DEVICE #1
DEVUR2	EQU	6	; USER DEFINED READER DEVICE #2
DEVUR3	EQU	7	; USER DEFINED READER DEVICE #3
DEVPTP	EQU	8	; PAPER TAPE PUNCH DEVICE
DEVUP1	EQU	9	; USER DEFINED PUNCH DEVICE #1
DEVUP2	EQU	10	; USER DEFINED PUNCH DEVICE #2
DEVUP3	EQU	11	; USER DEFINED PUNCH DEVICE #3
DEVLPT	EQU	12	; LINE PRINTER DEVICE
DEVUL1	EQU	13	; USER DEFINED LINE PRINTER DEVICE #1
DEVUL2	EQU	14	; USER DEFINED LINE PRINTER DEVICE #2
DEVUL3	EQU	15	; USER DEFINED LINE PRINTER DEVICE #3
DEVOPN	EQU	16	; OPEN COMMAND
DEVNAM	EQU	32	; NAME COMMAND
DEVCLS	EQU	48	; CLOSE COMMAND
DEVST	EQU	0	; STATUS COMMAND
DEVERR	EQU	32	; ERROR STATUS
DEVRD	EQU	64	; READABLE STATUS
DEVWR	EQU	128	; WRITABLE STATUS
DEVRW	EQU	192	; READ/WRITE READY STATUS
DEVDAT	EQU	12	; DEVICE DATA PORT

; DISK DEVICE
MAXDSK	EQU	16	; NUMBER OF DISK DEVICES
MAXXLT	EQU	64	; SIZE OF DISK XLT
MAXALV	EQU	320	; SIZE OF DISK ALV
MAXCKS	EQU	256	; SIZE OF DISK CSV
MAXPB	EQU	15	; SIZE OF DISK PB
DSKNUM	EQU	13	; DISK SELECT PORT
DSKCTL	EQU	14	; DISK CONTROL/STATUS PORT
SECSIZ	EQU	128	; TOTAL BYTES IN SECTOR
DSKOPN	EQU	4	; DISK OPEN STATUS/COMMAND
DSKCLS	EQU	8	; DISK CLOSE STATUS/COMMAND
DSKRD	EQU	1	; DISK READ STATUS/COMMAND
DSKWR	EQU	2	; DISK WRITE STATUS/COMMAND
DSKST	EQU	16	; DISK STATUS COMMAND
DSKPB	EQU	32	; DISK PARAMETER BLOCK COMMAND
DSKBSY  EQU	64	; DISK BUSY STATUS
DSKERR	EQU	128	; DISK ERROR STATUS
SECHI	EQU	15	; SECTOR HIGH BYTE PORT
SECLO	EQU	16	; SECTOR LOW BYTE PORT
TRKHI	EQU	17	; TRACK HIGH BYTE PORT
TRKLO	EQU	18	; TRACK LOW BYTE PORT

; CLOCK DEVICE
CLOCK0	EQU	19	; LOW WORD, LOW BYTE PORT
CLOCK1	EQU	20	; LOW WORD, HIGH BYTE PORT
CLOCK2	EQU	21	; HIGH WORD, LOW BYTE PORT
CLOCK3	EQU	22	; HIGH WORD, HIGH BYTE PORT

; TIME OF DAY DEVICE
TIMRD	EQU	23	; TIME OF DAY PORT
TIMS	EQU	0	; READ SECONDS COMMAND
TIMM	EQU	1	; READ MINUTES COMMAND
TIMH	EQU	2	; READ READ HOURS COMMAND
TIMDHI	EQU	3	; READ DAYS, HIGH BYTE COMMAND
TIMDLO	EQU	4	; READ DAYS, LOW BYTE COMMAND

; HOST FILE DEVICE
FILCTL	EQU	24	; CONTROL/STATUS PORT
FILOPN	EQU	0	; OPEN FILE COMMAND
FILCLS	EQU	1	; CLOSE FILE COMMAND
FILDEL	EQU	2	; DELETE FILE COMMAND
FILMAK	EQU	3	; MAKE FILE COMMAND
FILRD	EQU	4	; READ FILE COMMAND
FILWR	EQU	5	; WRITE FILE COMMAND
FILOK	EQU	0	; FILE OK STATUS
FILERR	EQU	255	; FILE ERROR STATUS
FCBHI	EQU	25	; FCB HIGH BYTE PORT
FCBLO	EQU	26	; FCB LOW BYTE PORT

	ORG	BIOS

; JUMP TABLE OF BIOS FUNCTIONS
	JMP	CBOOT	; 0  -- COLD BOOT
WBOOTE:	JMP	WBOOT	; 1  -- WARM BOOT
	JMP	CONIST	; 2  -- CONSOLE INPUT STATUS
	JMP	CONIN	; 3  -- CONSOLE INPUT
	JMP	CONOUT	; 4  -- CONSOLE OUTPUT
	JMP	LSTOUT	; 5  -- LIST OUTPUT
	JMP	PUNOUT	; 6  -- PUNCH OUTPUT
	JMP	RDRIN	; 7  -- READER INPUT
	JMP	HOMTRK	; 8  -- HOME DISK
	JMP	SELDSK	; 9  -- SELECT DISK
	JMP	SETTRK	; 10 -- SET TRACK NUMBER
	JMP	SETSEC	; 11 -- SET SECTOR NUMBER
	JMP	SETDMA	; 12 -- SET DMA ADDRESS
	JMP	RDSEC	; 13 -- READ DISK SECTOR
	JMP	WRSEC	; 14 -- WRITE DISK SECTOR
	JMP	LSTOST	; 15 -- LIST OUTPUT STATUS
	JMP	SECXLT	; 16 -- TRANSLATE SECTOR NUMBER
; EXTRA FUNCTIONS FOR USIM
	JMP	OPNFIL	; 17 -- OPEN HOST FILE
	JMP	CLSFIL	; 18 -- COSE HOST FILE
	JMP	DELFIL	; 19 -- DELETE HOST FILE
	JMP	MAKFIL	; 20 -- MAKE HOST FILE
	JMP	RDFIL	; 21 -- READ HOST FILE
	JMP	WRFIL	; 22 -- WRITE HOST FILE
	JMP	RDTIM	; 23 -- READ TIME OF DAY

; COLD BOOT BANNER DISPLAYS MEMORY SIZE AND CP/M VERSION
BANNER:	DB	13,10
	DB	MEMSIZ / 10 + '0'
	DB	MEMSIZ MOD 10 + '0'
	DB	'K CP/M vers '
	DB	CPMVER / 10 + '0'
	DB	'.'
	DB	CPMVER MOD 10 + '0'
	DB	13,10
	DB	0

; BIOS COLD BOOT FUNCTION
CBOOT:	LXI	SP,STACK
	; SET IOBYTE: LST=LPT, PUN=PTP, RDR=PTR, CON=TTY
	MVI	A,10010100B
	STA	IOBYTE
	; SET CURRENT USER=0 AND DISK=A
	XRA	A
	STA	USRDSK
	; DISPLAY BOOT BANNER
	LXI	B,BANNER
	CALL	PUTS
	; CCP AND BDOS ARE IN PLACE
GOCPM:	; ERROR IF FIRST INSTRUCTION OF CCP IS NOT "JMP"
	LDA	CCP
	CPI	0C3H
	JNZ	ERROR
	; ERROR IF FIRST INSTRUCTION OF BDOS IS NOT "JMP"
	LDA	BDOS+6
	CPI	0C3H
	JNZ	ERROR
	; PREPARE DEFAULT DMA POINTER
	LXI	B,USRBUF
	CALL	SETDMA
	; PREPARE "REBOOT: JMP WBOOTE"
	; PREPARE "SYSTEM: JMP BDOS+6"
	MVI	A,0C3H
	STA	REBOOT
	STA	SYSTEM
	LXI	H,WBOOTE
	SHLD	REBOOT+1
	LXI	H,BDOS+6
	SHLD	SYSTEM+1
	; CCP IN: C = USRDSK
	LDA	USRDSK
	MOV	C,A
	; ENABLE INTERRUPTS AND ENTER CCP
	EI
	JMP	CCP

; RETRY THE WARM BOOT IF THERE WAS AN ERROR
ERRMSG:	DB	13,10,'?SYSTEM',13,10,0
ERROR:	LXI	B,ERRMSG
	CALL	PUTS
	CALL	CONIN

; BIOS WARM BOOT FUNCTION
WBOOT:	LXI	SP,STACK
	; COPY CCP+BDOS INTO MEMORY
	XRA	A
	STA	CCP
	STA	BDOS+6
	; SELECT A:
	MVI	C,0
	CALL	SELDSK
	; LOAD FROM TRACK 0
	LXI	B,0
	CALL	SETTRK
	LXI	H,CCP+0*80H	; CCP + 0 * 80H
	LXI	B,0D02H		; 13 SECTORS STARTING WITH 2
	CALL	RDTRK		; 02 04 06 08 10 12 14 16 18 20 22 24 26
	LXI	H,CCP+1*80H	; CCP + 1 * 80H
	LXI	B,0C03H		; 12 SECTORS STARTING WITH 3
	CALL	RDTRK		; 03 05 07 09 11 13 15 17 19 21 23 25
	; LOAD FROM TRACK 1
	LXI	B,1
	CALL	SETTRK
	LXI	H,CCP+25*80H	; CCP + 25 * 80H
	LXI	B,0A01H		; 10 SECTORS STARTING WITH 1
	CALL	RDTRK		; 01 03 05 07 09 11 13 15 17 19
	LXI	H,CCP+26*80H	; CCP + 26 * 80H
	LXI 	B,0902H		; 9 SECTORS STARTING WITH 2
	CALL	RDTRK		; 02 04 06 08 10 12 14 16 18
	; ENTER CP/M
	JMP	GOCPM

; RDTRK -- READ EVERY OTHER SECTOR ON A TRACK
; IN: HL = DESTINATION ADDRESS
; IN: B = SECTORCOUNT
; IN: C = SECTORNUMBER
RDTRK:	PUSH	H
	PUSH	B
	MVI	B,0
	CALL	SETSEC
	PUSH	H
	POP	B
	CALL	SETDMA
	CALL	RDSEC
	JNZ	ERROR
	POP	B
	POP	H
	INR	H
	INR	C
	INR	C
	DCR	B
	JNZ	RDTRK
	RET

; PRINT A STRING
; IN: BC = ADDRESS OF ZERO-TERMINATED STRING
PUTS:	MVI	A,DEVTTY
	OUT	DEVCTL
	LDAX	B
	ORA	A
	RZ
	INX	B
	OUT	DEVDAT
	JMP	PUTS

; LOGICAL CON: DEVICE INPUT STATUS VIA IOBYTE
CONIST:	LDA	IOBYTE
        ANI	00000011B
        JZ	TTYIST
        CPI	00000001B
        JZ	CRTIST
        CPI	00000010B
        JZ	RDRIST

; PHYSICAL UC1: DEVICE INPUT STATUS
UC1IST:	MVI	A,DEVUC1
	JMP	DEVIST

; LOGICAL CON: DEVICE INPUT VIA IOBYTE
CONIN:	CAll	CONIST
	JZ	CONIN
	LDA	IOBYTE
        ANI	00000011B
        JZ	TTYIN
        CPI	00000001B
        JZ	CRTIN
        CPI	00000010B
        JZ	RDRIN

; PHYSICAL UC1: DEVICE INPUT
UC1IN:	MVI	A,DEVUC1
	JMP	DEVIN

; LOGICAL CON: DEVICE OUTPUT STATUS VIA IOBYTE
CONOST: LDA	IOBYTE
        ANI	00000011B
        JZ	TTYOST
        CPI	00000001B
        JZ	CRTOST
        CPI	00000010B
        JZ	LPTOST

; PHYSICAL UC1: DEVICE OUTPUT STATUS
UC1OST:	MVI	A,DEVUC1
	JMP	DEVOST

; LOGICAL CON: DEVICE OUTPUT VIA IOBYTE
CONOUT:	CALL	CONOST
	JZ	CONOUT
	LDA	IOBYTE
        ANI	00000011B
        JZ	TTYOUT
        CPI	00000001B
        JZ	CRTOUT
        CPI	00000010B
        JZ	LPTOUT

; PHYSICAL UC1: DEVICE OUTPUT
UC1OUT:	MVI	A,DEVUC1
	JMP	DEVOUT

; LOGICAL LST: DEVICE OUTPUT VIA IOBYTE
LSTOUT:	CALL	LSTOST
	JZ	LSTOUT
	LDA	IOBYTE
        ANI	11000000B
        JZ	TTYOUT
        CPI	01000000B
        JZ	CRTOUT
        CPI	10000000B
        JZ	LPTOUT

; PHYSICAL UL1: DEVICE OUTPUT
UL1OUT:	MVI	A,DEVUL1
	JMP	DEVOUT

; LOGICAL LST: DEVICE OUTPUT STATUS VIA IOBYTE
LSTOST:	LDA	IOBYTE
        ANI	11000000B
        JZ	TTYOST
        CPI	01000000B
        JZ	CRTOST
        CPI	10000000B
        JZ	LPTOST

; PHYSICAL UL1: DEVICE OUTPUT STATUS
UL1OST:	MVI	A,DEVUL1
	JMP	DEVOST

; LOGICAL PUN: DEVICE OUTPUT STATUS VIA IOBYTE
PUNOST:	LDA	IOBYTE
        ANI	00110000B
        JZ	TTYOST
        CPI	00010000B
        JZ	PTPOST
        CPI	00100000B
        JZ	UP1OST

; PHYSICAL UP2: DEVICE OUTPUT STATUS
UP2OST:	MVI	A,DEVUP2
	JMP	DEVOST

; LOGICAL PUN: DEVICE OUTPUT VIA IOBYTE
PUNOUT:	CALL	PUNOST
	JZ	PUNOUT
	LDA	IOBYTE
        ANI	00110000B
        JZ	TTYOUT
        CPI	00010000B
        JZ	PTPOUT
        CPI	00100000B
        JZ	UP1OUT

; PHYSICAL UP2: DEVICE OUTPUT
UP2OUT:	MVI	A,DEVUP2
	JMP	DEVOUT

; LOGICAL RDR: DEVICE INPUT STATUS VIA IOBYTE
RDRIST:	LDA	IOBYTE
        ANI	00001100B
        JZ	TTYIST
        CPI	00000100B
        JZ	PTRIST
        CPI	00001000B
        JZ	UR1IST

; PHYSICAL UR2: DEVICE INPUT STATUS
UR2IST:	MVI	A,DEVUR2
	JMP	DEVIST

; LOGICAL RDR: DEVICE INPUT VIA IOBYTE
RDRIN:	CALL	RDRIST
	JZ	RDRIN
	LDA	IOBYTE
        ANI	00001100B
        JZ	TTYIN
        CPI	00000100B
        JZ	PTRIN
        CPI	00001000B
        JZ	UR1IN

; PHYSICAL UR2: DEVICE INPUT
UR2IN:	MVI	A,DEVUR2
	JMP	DEVIN

; PHYSICAL TTY: DEVICE INPUT STATUS
TTYIST:	MVI	A,DEVTTY

; CHARACTER DEVICE INPUT STATUS
DEVIST:	OUT	DEVCTL
	IN	DEVCTL
	ANI	DEVRD

; RETURN STATUS -1 IF READY, 0 IF NOT
RETST:	ORA	A
	RZ
	MVI	A,255
	RET

; PHYSICAL TTY: DEVICE INPUT
TTYIN:	MVI	A,DEVTTY

; CHARACTER DEVICE INPUT
DEVIN:	OUT	DEVCTL
	IN	DEVDAT
	RET

; PHYSICAL TTY: DEVICE OUTPUT STATUS
TTYOST:	MVI	A,DEVTTY

; CHARACTER DEVICE OUTPUT STATUS
DEVOST:	OUT	DEVCTL
	IN	DEVCTL
	ANI	DEVWR
	JMP	RETST

; PHYSICAL TTY: DEVICE OUTPUT
TTYOUT:	MVI	A,DEVTTY

; CHARACTER DEVICE OUTPUT
DEVOUT:	OUT	DEVCTL
	MOV	A,C
	OUT	DEVDAT
	RET

; PHYSICAL CRT: DEVICE INPUT STATUS
CRTIST:	MVI	A,DEVCRT
	JMP	DEVIST

; PHYSICAL CRT: DEVICE INPUT
CRTIN:	MVI	A,DEVCRT
	JMP	DEVIN

; PHYSICAL CRT: DEVICE OUTPUT STATUS
CRTOST:	MVI	A,DEVCRT
	JMP	DEVOST

; PHYSICAL CRT: DEVICE OUTPUT
CRTOUT:	MVI	A,DEVCRT
	JMP	DEVOUT

; PHYSICAL LPT: DEVICE OUTPUT STATUS
LPTOST:	MVI	A,DEVLPT
	JMP	DEVOST

; PHYSICAL LPT: DEVICE OUTPUT
LPTOUT:	MVI	A,DEVLPT
	JMP	DEVOUT

; PHYSICAL PTP: DEVICE OUTPUT STATUS
PTPOST:	MVI	A,DEVPTP
	JMP	DEVOST

; PHYSICAL PTP: DEVICE OUTPUT
PTPOUT:	MVI	A,DEVPTP
	JMP	DEVOUT

; PHYSICAL UP1: DEVICE OUTPUT STATUS
UP1OST:	MVI	A,DEVUP1
	JMP	DEVOST

; PHYSICAL UP1: DEVICE OUTPUT
UP1OUT:	MVI	A,DEVUP1
	JMP	DEVOUT

; PHYSICAL PTR: DEVICE INPUT STATUS
PTRIST:	MVI	A,DEVPTR
	JMP	DEVIST

; PHYSICAL PTR: DEVICE INPUT
PTRIN:	MVI	A,DEVPTR
	JMP	DEVIN

; PHYSICAL UR1: DEVICE INPUT STATUS
UR1IST:	MVI	A,DEVUR1
	JMP	DEVIST

; PHYSICAL UR1: DEVICE INPUT
UR1IN:	MVI	A,DEVUR1
	JMP	DEVIN

; BIOS SELECT DISK FUNCTION
SELDSK:	LXI	H,0000H
	MOV	A,C
	CPI	MAXDSK
	RNC
	OUT	DSKNUM
	LXI	H,DPBASE
	MOV	A,H
	OUT	DMAHI
	MOV	A,L
	OUT	DMALO
	MVI	A,DSKPB
	OUT	DSKCTL
	RET

; BIOS HOME DISK FUNCTION
HOMTRK:	LXI	B,0000H

; BIOS SET DISK TRACK FUNCTION
SETTRK:	MOV	A,B
	OUT	TRKHI
	MOV	A,C
	OUT	TRKLO
	RET

; BIOS SET DISK SECTOR FUNCTION
; IN:	BC = SECTOR NUMBER, 0 < NUMBER <= MAXSEC
SETSEC:	DCX	B
	MOV	A,B
	OUT	SECHI
	MOV	A,C
	OUT	SECLO
	RET

; BIOS TRANSLATE SECTOR NUMBER FUNCTION
; IN:	BC = SECTOR OFFSET, 0 <= OFFSET < MAXSEC
; IN:	DE = TRANSLATE ARRAY BASE
; OUT:	HL = SECTOR NUMBER, 0 < NUMBER <= MAXSEC
SECXLT:	XCHG
	DAD	B
	MOV	L,M
	MVI	H,0
	RET

; BIOS SET DMA POINTER FUNCTION
SETDMA:	MOV	A,B
	OUT	DMAHI
	MOV	A,C
	OUT	DMALO
	RET

; BIOS READ DISK SECTOR FUNCTION
RDSEC:	MVI	A,DSKRD
	JMP	RDWR

; BIOS WRITE DISK SECTOR FUNCTION
WRSEC:	MVI	A,DSKWR
RDWR:	OUT	DSKCTL
	IN	DSKCTL
	ANI	DSKERR
	MVI	A,1
	RNZ
	XRA	A
	RET

; OPEN HOST FILE
; IN: DE = ADDRESS OF CP/M FCB
; OUT: A = 0 IF OK, -1 IF ERROR
OPNFIL:	CALL SETFCB
	MVI	A,FILOPN
CTLFIL:	OUT	FILCTL
	IN	FILCTL
	RET
SETFCB:	MOV	A,D
	OUT	FCBHI
	MOV	A,E
	OUT	FCBLO
	RET

; CLOSE HOST FILE
; IN: DE = ADDRESS OF CP/M FCB
; OUT: A = 0 IF OK, -1 IF ERROR
CLSFIL:	CALL	SETFCB
	MVI	A,FILCLS
	JMP	CTLFIL

; DELETE HOST FILE
; IN: DE = ADDRESS OF CP/M FCB
; OUT: A = 0 IF OK, -1 IF ERROR
DELFIL:	CALL	SETFCB
	MVI	A,FILDEL
	JMP	CTLFIL

; MAKE HOST FILE
; IN: DE = ADDRESS OF CP/M FCB
; OUT: A = 0 IF OK, -1 IF ERROR
MAKFIL:	CALL	SETFCB
	MVI	A,FILMAK
	JMP	CTLFIL

; READ HOST FILE
; IN: DE = ADDRESS OF CP/M FCB
; OUT: A = 0 IF OK, -1 IF ERROR
RDFIL:	CALL	SETFCB
	MVI	A,FILRD
	JMP	CTLFIL

; WRITE HOST FILE
; IN: DE = ADDRESS OF CP/M FCB
; OUT: A = 0 IF OK, -1 IF ERROR
WRFIL:	CALL	SETFCB
	MVI	A,FILWR
	JMP	CTLFIL

; TIME OF DAY
; IN: C = 0 TO GET, -1 TO SET
; IN: HL = ADDRESS OF SET TIME OF DAY
; OUT: HL = ADDRESS OF GET TIME OF DAY
RDTIM:	MOV	A,C
	ORA	A
	RNZ
	LXI	H,TIMBLK+4
	MVI	A,TIMS
	CALL	CTLTIM
	DCX	H
	MVI	A,TIMM
	CALL	CTLTIM
	DCX	H
	MVI	A,TIMH
	CALL	CTLTIM
	DCX	H
	MVI	A,TIMDHI
	CALL	CTLTIM
	DCX	H
	MVI	A,TIMDLO
CTLTIM:	OUT	TIMRD
	IN	TIMRD
	MOV	M,A
	RET

; DISK PARAMETER TABLE
DPBASE:	DW	XLT,0000H,0000H,0000H,DIRBUF,DPB,CSV,ALV

DIRBUF:	DS	128

DPB:	DS	MAXPB
XLT:	DS	MAXXLT
ALV:	DS	MAXALV
CSV:	DS	MAXCKS

; TIME OF DAY
TIMBLK:	DB	0	; +0: DATE LSB SINCE 1/1/78
	DB	0	; +1: DATE MSB
	DB	0	; +2: HOURS (BCD)
	DB	0	; +3: MINUTES (BCD)
	DB	0	; +4: SECONDS (BCD)

; BIOS STACK
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
STACK	EQU	$

	END
