*       NEWSIZE.S

newsize:
        movea.l 4(a7),a0        * ucitava adresu BASE PAGE u A0
        movea.l a0,a1
        lea     92(a0),a0       * ucitava adresu FCB
        lea     128(a1),a1      * ucitava adresu DMA

        clr.b   32(a0)          * open file
        move    #15,d0
        move.l  a0,d1
        trap    #2
        cmpi    #$ff,d0
        beq     error

        move    #26,d0          * set DMA address
        move.l  a1,d1
        trap    #2

        move    #20,d0          * read sequential
        move.l  a0,d1
        trap    #2

        cmpi    #$601a,(a1)
        bne     nocont
        move    #9,d0
        move.l  #cont,d1
        trap    #2
        bsr     tstrel

        move.l  2(a1),d0                * text len
        beq     notext
        movea.l #textn+40,a2
        bsr     out8hex

        movea.l #textn+16,a2            * text start
        move.l  22(a1),d0
        bsr     out8hex

        movea.l #textn+28,a2            * text end
        add.l   2(a1),d0
        subi.l  #1,d0
        bsr     out8hex

notext: move.l  6(a1),d0                * data len
        beq     nodata
        movea.l #datan+40,a2
        bsr     out8hex

        movea.l #datan+16,a2            * data start
        move.l  22(a1),d0
        add.l   2(a1),d0
        bsr     out8hex

        movea.l #datan+28,a2            * data end
        add.l   6(a1),d0
        subi.l  #1,d0
        bsr     out8hex

nodata: move.l  10(a1),d0               * bss len
        beq     nobss
        movea.l #bssn+40,a2
        bsr     out8hex

        movea.l #bssn+16,a2             * bss start
        move.l  22(a1),d0
        add.l   2(a1),d0
        add.l   6(a1),d0
        bsr     out8hex

        movea.l #bssn+28,a2             * bss end
        add.l   10(a1),d0
        subi.l  #1,d0
        bsr     out8hex

nobss:  move.l  14(a1),d0               * symbol len
        beq     nosym
        movea.l #symn+40,a2
        bsr     out8hex

nosym:  move    #9,d0
        move.l  #text1,d1
        trap    #2

        bra     exit

nocont: cmpi    #$601b,(a1)
        bne     noprog
        move    #9,d0
        move.l  #ncont,d1
        trap    #2
        bsr     tstrel

        move.l  2(a1),d0                * text len
        beq     notex
        movea.l #textn+40,a2
        bsr     out8hex

        movea.l #textn+16,a2            * text start
        move.l  22(a1),d0
        bsr     out8hex

        movea.l #textn+28,a2            * text end
        add.l   2(a1),d0
        subi.l  #1,d0
        bsr     out8hex

notex:  move.l  6(a1),d0                * data len
        beq     nodat
        movea.l #datan+40,a2
        bsr     out8hex

        movea.l #datan+16,a2            * data start
        move.l  28(a1),d0
        bsr     out8hex

        movea.l #datan+28,a2            * data end
        add.l   6(a1),d0
        subi.l  #1,d0
        bsr     out8hex

nodat:  move.l  10(a1),d0               * bss len
        beq     nobs
        movea.l #bssn+40,a2
        bsr     out8hex

        movea.l #bssn+16,a2             * bss start
        move.l  32(a1),d0
        bsr     out8hex

        movea.l #bssn+28,a2             * bss end
        add.l   10(a1),d0
        subi.l  #1,d0
        bsr     out8hex

nobs:   move.l  14(a1),d0               * symbol len
        beq     nosy
        movea.l #symn+40,a2
        bsr     out8hex

nosy:   move    #9,d0
        move.l  #text1,d1
        trap    #2

        bra     exit

noprog: move    #9,d0
        move.l  #noprg,d1
        trap    #2
        bra     exit

tstrel: cmpi    #0,26(a1)
        bne     norel
        move    #9,d0
        move.l  #rel,d1
        trap    #2
norel:  rts


out8hex:
        move.w  #7,d2           * d0.l podatak koji se konvertuje
loop:   rol.l   #4,d0           * a2.l adresa na koju se konvertuje
        bsr     hex             * d1.b i d2.w radni registri
        dbra    d2,loop
        rts

hex:    move.b  d0,d1
        andi.b  #$0f,d1
        cmpi.b  #$0a,d1
        blt     noadd
        addi.b  #7,d1
noadd:  addi.b  #'0',d1
        move.b  d1,(a2)+
        rts

error:  move    #9,d0           * print string
        move.l  #string,d1
        trap    #2

exit:   move    #0,d0           * return to CP/M-68K
        trap    #2

        data

string: dc.b    13,10,'CANNOT OPEN FILE!',13,10,'$'
noprg:  dc.b    13,10,'NO COMMAND FILE!',13,10,'$'

cont:   dc.b    13,10,' ------------------------------------------------- '
        dc.b    13,10,'|           CONTIGUOUS PROGRAM SEGMENTS           |'
        dc.b    '$'
ncont:  dc.b    13,10,' ------------------------------------------------- '
        dc.b    13,10,'|         NON CONTIGUOUS PROGRAM SEGMENTS         |'
        dc.b    '$'
rel:    dc.b    13,10,'|-------------------------------------------------|'
        dc.b    13,10,'|              RELOCATION BITS EXIST              |'
        dc.b    '$'
text1:  dc.b    13,10,'|-------------------------------------------------|'
        dc.b    13,10,'|              START:       END:        LEN:      |'
        dc.b    13,10,'|-------------------------------------------------|'
textn:  dc.b    13,10,'| TEXT:       --------    --------    --------    |'
datan:  dc.b    13,10,'| DATA:       --------    --------    --------    |'
bssn:   dc.b    13,10,'| BSS:        --------    --------    --------    |'
symn:   dc.b    13,10,'| SYMBOL:     --------    --------    --------    |'
        dc.b    13,10,' ------------------------------------------------- '
        dc.b    13,10,'$'

        end
