     STRING \ all data entered with GETF and UPDF is in string form
     	CUSTOMER,	\ customer name
     	ADDRESS,	\ 
     	CITY,		\
     	STATE,		\
     	ZIP,		\ validated for numerical value
     	PHONE,		\ numerical
     	PAYMENT(1),	\ method of payment, and account no.
     	QTY(1),		\ quanity of each item
     	DESCRIPTION(1),	\ brief written description
     	PART.NO(1),	\ 5 digit number, checked if valid 
     	PRICE.EA(1),	\ normal price written out, but may be sale
     	TOTAL(1) 	\ QTY * PRICE.EA

REM -- constants used in the program
     ON$ = "0"					REM make a field visible
     OFF$ = "1"					REM make a field invisible
     LST.SZ% = 50				REM size of parts list
     TABS$ = "              "  			REM tabs for output

     DIM \ 
     	PAYMENT(1), 	\ account number is second value
     	QTY(4),		\ only 5 different items allowed on one order
     	DESCRIPTION(4),	\
     	PART.NO(4),	\
     	PRICE.EA(4),	\
     	TOTAL(4),	\
     	PART.LST$(LST.SZ%,1),\
     	PRICE$(LST.SZ%) \

REM -- include the Display Manager runtime library definitions
     %INCLUDE DMEXTR.BAS

REM -- get screen handling control code from installation file
     IF END # 1 THEN ERR1			REM if no term file, then abort
     OPEN "CURRENT.TRM" AS 1
     READ # 1;TERM$
     CLOSE 1

REM -- set part no. list up
     IF END # 2 THEN ERR2 			REM if no file, then abort
     OPEN "PARTS.LST" AS 2
     IF END # 2 THEN S.LS
     FOR CNT% = 0 TO LST.SZ% - 1
     	READ # 2; PART.LST$(CNT%,0),PART.LST$(CNT%,1),PRICE$(CNT%)
     NEXT
S.LS:PART.LST$(CNT% + 1,0) = ""			REM end of list
     CLOSE 2

REM -- assign Display numbers, these can be changed as needed
     PHONE.ORDER% = 1				REM main display
     HELP% = 2					REM part no. reference


REM -- set error output messages for fatal Display Manager errors
 	INIDM$ = "ERROR: Initialization failure" 
 	OPNIS$ = "ERROR: Display file not found"
 	DISD$ = "ERROR: Display not found"      
 	POS$ = "ERROR: Field missing"	   
 	NXT$ = "ERROR: Next field missing"	   
 	PUT$ = "ERROR: Write to field failure" 
 	CUR$ = "ERROR: Cursor On/Off failure"
    	CLSDIS$ = "ERROR: Can't close display file"

REM *****************************************************
REM *all non Display Manager functions are defined here *   
REM *****************************************************

REM -- most DM functs return -1 if err, they are fatal, so abort
     DEF DM.ERR(F.RET%,ERR.TYPE$)
     	IF F.RET% >= 0 THEN RETURN		REM not an error
     	PRINT : PRINT				REM clear some space for err
     	PRINT ERR.TYPE$				REM output message
     	STOP					REM fatal so quit
     FEND

REM -- find if part number exists
     DEF SEARCH(PART.NO$)
     	INTEGER SEARCH				REM return array position
     	FOR CNT% = 0 TO LST.SZ% - 1
     		IF PART.LST$(CNT%,0) = PART.NO$ \
     			THEN SEARCH = CNT% : \
     			     RETURN
     		IF PART.LST$(CNT%,0) = "" \
     			THEN GOTO ELST
     	NEXT
ELST:	SEARCH = -1
     FEND

REM -- move relative to next input field, and turn on prompt, get input
     DEF GET.ENTRY
     	STRING GET.ENTRY
     	RET.ERR% = NXTF(2)			REM move to next input field
    	CALL DM.ERR(RET.ERR%,NXTF$)
     	ATTR$ = SETF(PRM.ON$)			REM turn on prompt
     	INP$ = GETF				REM input from field
CONT:	IF ENDF = 27 \				REM ESC key to exit
     		THEN CALL CLRSCR : \		REM clear the screen.
		     RET.ERR% = CLSDIS : \	
    		     CALL DM.ERR(RET.ERR%,CLSDIS$) : \
     		     STOP
     	IF ENDF <> 0 AND ENDF <> 26 \		REM control char, other than Z
     		THEN GOTO RETR			REM ignore char and continue
     	GET.ENTRY = INP$
     	ATTR$ = SETF(PRM.OFF$)			REM turn off prompt
     	RETURN
RETR:	RET$ = RESF(-1)				REM save position
REM    	RET.ERR% = PUTF(INP$ + PROMPT$)		REM replace initial chars
REM    	CALL DM.ERR(RET.ERR%,PUTF$)
     	INP$ = RESF(1)				REM resume input
     	GOTO CONT				REM continue
     FEND

REM -- display error message, and help message
     DEF ERR.MSG(POS%,ONOFF$)
     	RET% = POSF(0)				REM @@@store current position
     	RET.ERR% = POSF(POS%)
    	CALL DM.ERR(RET.ERR%,POSF$)
     	ATTR$ = SETF(ONOFF$)			REM turn off/on message
     	RET.ERR% = POSF(RET%)			REM return to original pos.
    	CALL DM.ERR(RET.ERR%,POSF$)
     FEND

REM *******************************************
REM *start program here. Main loop from LOOP: *
REM *******************************************

     RET.ERR% = INITDM(TERM$)	 			REM init the library
     CALL DM.ERR(RET.ERR%,INITDM$)
     AVAIL.ATTR$ = RETDM				REM CRT attrs avail.
     IF MID$(AVAIL.ATTR$,3,1) <> "0" \ inverse video supported
     	THEN PRM.ON$ = "031" : \
     	     PRM.OFF$ = "330" : \ use for prompts
     	ELSE PRM.ON$ = "0" : \
     	     PRM.OFF$ = "3"   				REM just initials


REM -- open display file, show it, and position to the first field
     RET.ERR% = OPNDIS("ORDERS.DIS")			REM open the file
     CALL DM.ERR(RET.ERR%,OPNDIS$)
LOOP:RET.ERR% = DISPD(PHONE.ORDER%)			REM show the display
     CALL DM.ERR(RET.ERR%,DISPD$)
     RET.ERR% = NXTF(-10)				REM 1st field
     CALL DM.ERR(RET.ERR%,NXTF$)
     PROMPT$ = "___________________"			REM initials

REM -- all prompts are inverse video if possible, underlines otherwise
     CUSTOMER = GET.ENTRY				REM use relative move-
     ADDRESS = GET.ENTRY				REM ment and GETF
     CITY = GET.ENTRY
     STATE = GET.ENTRY					REM alphabetic only
     ZIP = GET.ENTRY					REM numerical valid-
     PHONE = GET.ENTRY					REM ation by DM
PAYM:PAYMENT(0) = GET.ENTRY				REM A, B, or C only
     IF MATCH(PAYMENT(0),"ABC",1) = 0 OR \
        PAYMENT(0) = "" \ not valid answer
     	THEN CALL ERR.MSG(100,ON$) : \
     	     RET.ERR% = NXTF(-2) : \
    	     CALL DM.ERR(RET.ERR%,NXTF$) : \
     	     GOTO PAYM \ output error message, retry
     	ELSE RET.ERR% = NXTF(3) : \
      	     CALL DM.ERR(RET.ERR%,NXTF$) 	REM goto next col
     IF PAYMENT(0) = "A" \ personal credit account
     	THEN RET.ERR% = PUTF("CCOUNT") : \ rest of the word
    	     CALL DM.ERR(RET.ERR%,PUTF$) : \ 
     	     PAYMENT(1) = GET.ENTRY \ get account no.
     ELSE IF PAYMENT(0) = "B" \ bank credit card
     	THEN RET.ERR% = PUTF("ANK CARD") : \
    	     CALL DM.ERR(RET.ERR%,PUTF$) : \
     	     PAYMENT(1) = GET.ENTRY \
     ELSE IF PAYMENT(0) = "C" \ cash on delivery
     	THEN RET.ERR% = PUTF(".O.D.") : \
    	     CALL DM.ERR(RET.ERR%,PUTF$)
     CALL ERR.MSG(100,OFF$)				REM turn it off

REM -- take order now
     RET.ERR% = POSF(75)	 			REM turn on message --
     CALL DM.ERR(RET.ERR%,POSF$)			REM about ending entry
     ATTR$ = SETF("0")	
     PROMPT$ = "                "			REM initial characters
     ORDER.NO% = 0					REM up to five 
ORDR:QTY(ORDER.NO%) = GET.ENTRY				REM quantity of items
     IF QTY(ORDER.NO%) = "0" THEN GOTO TTLS  		REM stop entry
     DESCRIPTION(ORDER.NO%) = GET.ENTRY
     CALL ERR.MSG(76,ON$)         	  		REM ^Z reference msg --
PART:PART.NO(ORDER.NO%) = GET.ENTRY			REM only for this input
HRET:IF ENDF = 26 \ CTRL Z for part no. reference display. complete input
     	THEN GOTO HELP
     PART% = SEARCH(PART.NO(ORDER.NO%))
     IF PART% = -1 \ not valid part number
     	THEN CALL ERR.MSG(101,ON$) : \
     	     RET.ERR% = NXTF(-2) : \
    	     CALL DM.ERR(RET.ERR%,NXTF$) : \
     	     GOTO PART					REM retry
     CALL ERR.MSG(101,OFF$)				REM turn off err msg
     CALL ERR.MSG(76,OFF$)				REM turn off ^Z msg
     RET.ERR% = NXTF(2)					REM write normal price 
     CALL DM.ERR(RET.ERR%,NXTF$)
     RET.ERR% = PUTF(PRICE$(PART%))
     CALL DM.ERR(RET.ERR%,PUTF$)
     ATTR$ = SETF(PRM.ON$)
PTRY:PRICE.EA(ORDER.NO%) = UPDF				REM if CR, get initial 
REM --note that this field does not trap bad characters, (ESC not caught)
     ATTR$ = SETF(PRM.OFF$)
     RET.ERR% = NXTF(3)					REM field is for total
     CALL DM.ERR(RET.ERR%,NXTF$)
     TOTAL(ORDER.NO%) = STR$(VAL(QTY(ORDER.NO%)) * \
		    VAL(PRICE.EA(ORDER.NO%)))
     RET.ERR% = PUTF(TOTAL(ORDER.NO%))
     CALL DM.ERR(RET.ERR%,PUTF$)
     ORDER.NO% = ORDER.NO% + 1				REM only five allowed
     IF ORDER.NO% < 5 THEN GOTO ORDR 			REM can break w/QTY = 0
     ORDER.NO% = 4					REM only 0 to 4 allowed
TTLS:SALE = 0						REM calc total bill
     FOR CNT% = 0 TO ORDER.NO%
     	SALE = SALE + VAL(TOTAL(CNT%))
     NEXT
     RET.ERR% = POSF(26)	
     CALL DM.ERR(RET.ERR%,POSF$)
     RET.ERR% = PUTF(STR$(SALE))			REM write total sale
     CALL DM.ERR(RET.ERR%,PUTF$)
     RET.ERR% = NXTF(20)				REM wait till ready
     CALL DM.ERR(RET.ERR%,NXTF$)
     ATTR$ = SETF("0")					REM turn on prompt
     RET$ = GETF					REM wait for CR
     IF ENDF = 27 \
	THEN GOTO DONE					REM ESC to exit

REM **********************
REM *output data to file *
REM **********************
     GOTO LOOP						REM next order


REM -- the following subroutine shows the part numbers with a description to
REM -- help the operator remember the part number. then must redisplay order
     DEF WRITEF(OUT$)
	RET.ERR% = NXTF(2)				REM goto input field
	CALL DM.ERR(RET.ERR%,NXTF$)
	ATTR$ =  SETF("0")				REM turn on field
	RET.ERR% = PUTF(OUT$)				REM put in old data
	CALL DM.ERR(RET.ERR%,PUTF$)
	RET$ = RETF					REM check if payment--
	IF POSF(0) = 8   \output rest in ajoining output field
		THEN RET.ERR% = NXTF(3) : \
		     CALL DM.ERR(RET.ERR%,NXTF$) : \
		     RET.ERR% = PUTF(MID$(OUT$,2,LEN(OUT$))) : \
		     CALL DM.ERR(RET.ERR%,PUTF$)
     FEND

HELP:RET$ = RESF(-1) : CALL CURS("1")			REM save place
     RET.ERR% = DISPD(HELP%)				REM show part no. list
     CALL DM.ERR(RET.ERR%,DISPD$)
FIRS:CNT% = 0
     PAGE% = 0						REM write out list
NXTL:RET.ERR% = POSF(CNT% + 1)	
     CALL DM.ERR(RET.ERR%,POSF$)
     IF PART.LST$(CNT% + PAGE%,0) <> "" \  output to end of list
     	THEN TEMP$ = PART.LST$(CNT% + PAGE%,0) + TABS$ + \
		     PART.LST$(CNT% + PAGE%,1) : \
     	     RET.ERR% = PUTF(TEMP$) : \
    	     CALL DM.ERR(RET.ERR%,PUTF$) : \
	     CALL SETF("0") \
     	ELSE CNT% = -1 
     CNT% = CNT% + 1
     IF CNT% <> 0 AND CNT% < 22 THEN GOTO NXTL
     RET.ERR% = POSF(100)
     CALL DM.ERR(RET.ERR%,POSF$)			REM next page, or exit 
HRTR:RET$ = GETF
     IF RET$ = CHR$(27) THEN GOTO REDS			REM ESC, return 
     IF RET$ <> CHR$(26) \           			REM ^Z, next w/wrap 
	THEN GOTO HRTR
     IF CNT% = 0 THEN GOTO FIRS
     PAGE% = PAGE% + 21					REM next page
     CNT% = 0
     GOTO NXTL
REDS:RET.ERR% = DISPD(PHONE.ORDER%)			REM bring back old disp
     CALL DM.ERR(RET.ERR%,DISPD$)
     RET.ERR% = NXTF(-10)				REM 1st field, then 1st
     CALL DM.ERR(RET.ERR%,NXTF$)			REM in field to write 
     CALL WRITEF(CUSTOMER)
     CALL WRITEF(ADDRESS)
     CALL WRITEF(CITY)
     CALL WRITEF(STATE)
     CALL WRITEF(ZIP)
     CALL WRITEF(PHONE)
     ON MATCH(PAYMENT(0),"ABC",1) GOTO ACCT,BANK,PCOD
ACCT:CALL WRITEF("ACCOUNT")
     CALL WRITEF(PAYMENT(1))
     GOTO HCON
BANK:CALL WRITEF("BANK CARD")
     CALL WRITEF(PAYMENT(1))
     GOTO HCON
PCOD:CALL WRITEF("C.O.D.")
     RET.ERR% = NXTF(2)
     CALL DM.ERR(RET.ERR%,NXTF$)
HCON:CALL ERR.MSG(75,ON$)				REM exit message
     FOR CNT% = 0 TO ORDER.NO% - 1
     	CALL WRITEF(QTY(CNT%))
	CALL WRITEF(DESCRIPTION(CNT%))
	CALL WRITEF(PART.NO(CNT%))
	CALL WRITEF(PRICE.EA(CNT%))
	RET.ERR% = NXTF(3)
 	CALL DM.ERR(RET.ERR%,NXTF$)
	RET.ERR% = PUTF(TOTAL(CNT%))
     NEXT
     CALL WRITEF(QTY(ORDER.NO%))
     CALL WRITEF(DESCRIPTION(ORDER.NO%))
     CALL WRITEF(PART.NO(ORDER.NO%))
     CALL SETF(PRM.ON$)
     CALL CURS("0")
     PART.NO(ORDER.NO%) = RESF(1)
     CALL SETF(PRM.OFF$)
     GOTO HRET

ERR1:PRINT "ERROR: No current terminal file"
     PRINT "(put control code in 'CURRENT.TRM')"
     STOP 						REM no terminal codes
ERR2:PRINT "ERROR: No part no. reference file"
     STOP						REM no price list --
REM -- with part no, description, & price
DONE:CALL CLRSCR					REM clear the screen.
     RET.ERR% = CLSDIS					REM close Display file
     CALL DM.ERR(RET.ERR%,CLSDIS$)
     STOP

